"""Filter model for the global Assign BC table."""
# 1. Standard python modules

# 2. Third party modules
from PySide2.QtCore import QSortFilterProxyModel, Qt

# 3. Aquaveo modules

# 4. Local modules


COL_IDX_TYPE = 0
COL_IDX_DEFINE = 1


class GlobalBcsFilterModel(QSortFilterProxyModel):
    """A model to set enabled/disabled states."""

    def __init__(self, parent=None):
        """Initializes the filter model.

        Args:
            parent (QWidget): The parent object.
        """
        super().__init__(parent)

    def headerData(self, section, orientation, role=Qt.DisplayRole):  # noqa: N802
        """Returns the data for the given role and section in the header.

        Args:
            section (int): The section.
            orientation (:obj:`Qt.Orientation`): The orientation.
            role (int): The role.

        Returns:
            The data.
        """
        if role != Qt.DisplayRole:
            return super().headerData(section, orientation, role)

        if orientation == Qt.Vertical:
            return str(section + 1)
        else:
            return super().headerData(section, orientation, role)

    def flags(self, index):
        """Set flags for an item in the model.

        Args:
            index (QModelIndex): The item's model index

        Returns:
            Qt.ItemFlags: Updated flags for the item
        """
        flags = super().flags(index)
        col = index.column()

        if col in [COL_IDX_TYPE, COL_IDX_DEFINE]:
            flags = flags & (~Qt.ItemIsEditable)
            flags |= Qt.ItemIsEnabled
        else:
            flags |= Qt.ItemIsEnabled
        return flags
